/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluid;
import slimeknights.tconstruct.library.modifiers.spilling.SpillingFluidManager;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.ability.armor.WettingModifier;

public class SpillingModifier
extends WettingModifier {
    @Override
    public ToolAttackContext createContext(LivingEntity self, @Nullable Player player, @Nullable Entity attacker, FluidStack fluid) {
        LivingEntity living;
        assert (attacker != null);
        SpillingModifier.spawnParticles(attacker, fluid);
        return new ToolAttackContext(self, player, InteractionHand.MAIN_HAND, attacker, attacker instanceof LivingEntity ? (living = (LivingEntity)attacker) : null, false, 1.0f, false);
    }

    @Override
    protected boolean doesTrigger(DamageSource source, boolean isDirectDamage) {
        return source.m_7639_() != null && isDirectDamage;
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        SpillingFluid recipe;
        FluidStack fluid;
        if (damageDealt > 0.0f && context.isFullyCharged() && !(fluid = this.getFluid(tool)).isEmpty() && (recipe = SpillingFluidManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            FluidStack remaining = recipe.applyEffects(fluid, level, context);
            SpillingModifier.spawnParticles(context.getTarget(), fluid);
            Player player = context.getPlayerAttacker();
            if (player == null || !player.m_7500_()) {
                this.setFluid(tool, remaining);
            }
        }
        return 0;
    }
}

